%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%-------------------------------------------------
% Version réalisée en partant du template des JNM2017 alors réalisé par Kevin NADAUD (kevin.nadaud@gmail.com)
%-------------------------------------------------
% Update JNM 2026 : Logo superposé à droite en conservant le centrage du texte passant en "picture"
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}
 
\ProvidesClass{jnm}[2014/11/14 template resume proceeding jnm, V1.0, kevin nadaud]
 
% classe de base
 \LoadClass[a4paper,10pt,twocolumn]{article} 

%%%%%%%%%%%%%%%%%%%%%%chargement des packages n\'ecessaires
\RequirePackage[top=2.5cm,bottom=2.5cm,right=2cm,left=2cm,headheight=1.25cm,headsep=10pt,marginparsep=0pt,columnsep=0.75cm,footskip=1.2cm]{geometry}
\RequirePackage{fancyhdr}
\RequirePackage{graphicx}
\RequirePackage[english,french]{babel}
\RequirePackage[small, font=bf, labelfont={up,bf}, justification=centering]{caption}
\RequirePackage{lmodern}
\renewcommand{\sfdefault}{phv}
\renewcommand{\rmdefault}{ptm}
\renewcommand{\ttdefault}{pcr}
\normalfont\selectfont
%%%%%%%%%%%%%%%%%%%%%%change le style du titre

\renewcommand{\@maketitle}{
\hfill
\begin{picture}(\textwidth,5)  % Largeur = \textwidth, hauteur = 5cm (ajustez à la hauteur de votre texte)
    \put(0,0){
	\begin{minipage}[c]{\linewidth}
	\begin{center}% \sf
	{\fontsize{10}{10}\selectfont XXIV\textsuperscript{\`emes} Journ\'ees Nationales Microondes\\[0,5em] 19-22 mai 2026 - LILLE\par}
	\end{center}
    \end{minipage}
    }
    \put(\dimexpr\textwidth - 2cm\relax, -0.4cm){  % Place le logo à droite (x = largeur totale - 3cm), au milieu vertical (y=2.5cm)
      \includegraphics[width=2cm]{./JNM_2026_Logo.jpg}  % Ajustez largeur (ex. 3cm ou 0.15\textwidth)
    }
  \end{picture}
		\begin{center}%
			\vspace{24pt}%{1.1cm}
			{\fontsize{16}{16}\selectfont \textbf{\@title} \par}
			\vspace{1.4em}
			{\@author\par}
			\vspace{0.5em}
			{\textit\@institute \par}
			{\textit\@email \par}
		\end{center}
		\par
}
\def\email#1{\def\@email{#1}}
	\def\institute#1{\def\@institute{#1}}
%%%%%%%%%%%%%%%%%%%%%%%change le style des sections
\parindent=0.5cm
\def\section{\@startsection{section}{1}{\z@}%
{5pt plus 1pt minus 1pt}%
{4pt plus 1pt minus 1pt}%
{\normalfont\large\bfseries}}%

\def\subsection{\@startsection{subsection}{2}{\parindent}%
{3pt plus 1pt minus 1pt}%
{3pt plus 1pt minus 1pt}%
{\normalfont\normalsize\itshape}}%

\def\subsubsection{\@startsection{subsubsection}{3}{2\parindent}
{3pt plus 1pt minus 1pt}%
{3pt plus 1pt minus 1pt}%
{\normalfont\normalsize\itshape}}%


%%%%%%%%%%%%%%%%%%%%%%changement de la num\'erotation
\renewcommand{\thesection}{\arabic{section}.}
\renewcommand{\thesubsection}{\arabic{section}.\alph{subsection}.}
\renewcommand{\thesubsubsection}{\arabic{section}.\alph{subsection}.\alph{subsubsection}.}
%%%%%%%%%%%%%%%%%%%%%r\'ed\'efinition plain
\fancypagestyle{plain}{%
\fancyhf{} % vide l'??en-t\^ete et le pied~de~page.
\fancyfoot[C]{\normalfont\sf\small XXIV\textsuperscript{\`emes} Journ\'ees Nationales Microondes, 19-22 mai 2026 - Lille}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}}
%%%%%%%%%%%%%%%%%%%%%d\'efinition my fancy
\fancypagestyle{myfancy}{%
\fancyhf{}
\fancyfoot[C]{\normalfont\sf\small XXIV\textsuperscript{\`emes} Journ\'ees Nationales Microondes, 19-22 mai 2026 - Lille}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
}
\pagestyle{myfancy}
%%%%%%%%%%%%%%%%%%%%% style figure
\addto\captionsfrench{\def\figurename{Figure}}
\captionsetup{labelsep=period}
\addto\captionsfrench{\def\tablename{Tableau}}

\renewcommand{\figurename}{\normalfont Figure}

%%%%%%%%%%%%%%%%%%%%% Abstract
\def\abstractname{R\'esum\'e}
\def\abstract{\normalfont
	\noindent\itshape\leavevmode\kern-1pt\textbf{\abstractname}\ ---\relax
}
\def\endabstract{\relax\vspace{1.34ex}\par
	\normalfont\normalsize
}
%%%%%%%%%%%%%%%%%%% keywords
\def\keywordsname{Mots cl\'es}
\def\keywords{\normalfont
	\noindent\itshape\leavevmode\kern-1pt\textbf{\keywordsname}\ ---\relax
}
\def\endkeywords{\relax\vspace{1.34ex}\par
	\normalfont\normalsize
}
